---
generated_at: 2026-01-21 16:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Invalid Objects

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00004.sql` (行1-220)
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1062-1141)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行6)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは4である | E-01（行15: p_id=>4） | ○ |
| C-02 | エイリアスはINVALID-OBJECTSである | E-01（行17: p_alias=>'INVALID-OBJECTS'） | ○ |
| C-03 | Protection LevelはCである | E-01（行22: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | データソースはQA_TEST_RUN_INVALID_OBJECTSテーブル | E-01（行32: p_query_table=>'QA_TEST_RUN_INVALID_OBJECTS'） | ○ |
| C-06 | WHERE条件にQATO_QATR_ID = :P4_QATR_IDを使用 | E-01（行34: p_query_where=>'QATO_QATR_ID = :P4_QATR_ID'） | ○ |
| C-07 | インタラクティブ・レポートタイプを使用 | E-01（行36: p_plug_source_type=>'NATIVE_IR'） | ○ |
| C-08 | QATO_OBJECT_NAMEカラムが表示順序10で定義 | E-01（行78-92: display_order=>10） | ○ |
| C-09 | QATO_OBJECT_DETAILSカラムが表示順序20で定義 | E-01（行93-107: display_order=>20） | ○ |
| C-10 | データなしメッセージは「No data found.」 | E-01（行66: p_no_data_found_message=>'No data found.'） | ○ |
| C-11 | 検索バーは非表示 | E-01（行69: p_show_search_bar=>'N'） | ○ |
| C-12 | P4_QATR_IDはHidden項目 | E-01（行165: p_display_as=>'NATIVE_HIDDEN'） | ○ |
| C-13 | CLOSEボタンはDynamic Actionでダイアログを閉じる | E-01（行113-128, 186-207） | ○ |
| C-14 | AutocompleteはOFFに設定 | E-01（行20: p_autocomplete_on_off=>'OFF'） | ○ |
| C-15 | p_save_scheme_faulty_objectsで違反オブジェクトをINSERT | E-02（行1062-1070） | ○ |
| C-16 | p_handle_test_resultからp_save_scheme_faulty_objectsを呼び出し | E-02（行1130-1132） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_TEST_RUN_INVALID_OBJECTSテーブルが正しく定義されているか確認
- [ ] Dashboard画面からの遷移リンク（Details）が正しく設定されているか確認
- [ ] 大量の違反オブジェクトがある場合のレポートパフォーマンスを確認
- [ ] QATO_OBJECT_DETAILSカラムに長い文字列が入った場合の表示を確認
